/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops.beans;

import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;

public class TimeRangeBean
extends PanelBean
implements DataBean {
    private static final String CLASS_NAME = "[TimeRangeBean] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String ALL_CHOICE = "AllItem";
    private static final String CANCEL = "CANCEL";
    private static final String CHOICE_FIELD = "NTRChoice";
    private static final String DAYS_CHOICE = "DaysItem";
    private static final String DISPLAY_FILE = "DisplayInfoOutput";
    private static final String MONTHS_CHOICE = "MonthsItem";
    private static final String NUMBER_FIELD = "EntryFieldRangeNumber";
    private static final String OK_BUTTON = "OKButton";
    private static final String PANEL_NAME = "TimeRangePanel";
    private static final String RESET_BUTTON = "ResetButton";
    private static final String WEEKS_CHOICE = "WeeksItem";
    private String m_sDisplayInfoOutput;
    private double m_dEntryFieldRangeNumber;
    private String[] m_sNTRChoiceSelection;
    private int initialAmount;
    private String initialChoice;
    private String initialString;

    public TimeRangeBean(String name, int amount, String choice, LocalizableText initialText) {
        Trace.trace(TRACE_MASKT, "[TimeRangeBean] >> TimeRangeBean()");
        Trace.trace(TRACE_MASKT, "[TimeRangeBean]    Amount = " + amount);
        Trace.trace(TRACE_MASKT, "[TimeRangeBean]    Choice = " + choice);
        Trace.trace(TRACE_MASKT, "[TimeRangeBean]    Text   = " + initialText);
        this.setBeanName(name);
        this.initialAmount = amount;
        this.initialChoice = choice;
        this.initialString = initialText.toString();
        Trace.trace(TRACE_MASKT, "[TimeRangeBean] << TimeRangeBean()");
    }

    public void prepare() {
        this.setDisplayInfoOutput(this.initialString);
        this.setEntryFieldRangeNumber(this.initialAmount);
        this.setNTRChoiceSelection(new String[]{this.initialChoice});
        this.userTaskManager.refreshAllElements();
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, ">> panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        String elementName = event.getElementName();
        String actionCommand = event.getActionCommand();
        if (actionCommand.endsWith(OK_BUTTON)) {
            boolean dataValid = true;
            try {
                this.userTaskManager.storeAllElements();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[TimeRangeBean]    Data validation failure ... ignore update ...");
                dataValid = false;
            }
            if (dataValid) {
                double amount = this.getEntryFieldRangeNumber();
                String choice = this.getNTRChoiceSelection()[0];
                Trace.trace(TRACE_MASKF, "[TimeRangeBean] \tAmount = " + amount);
                Trace.trace(TRACE_MASKF, "[TimeRangeBean] \tChoice = " + choice);
                Object[] data = new Object[]{new Integer((int)amount), choice};
                this.sendTaskletRequest(actionCommand, data);
            }
        } else if (elementName.endsWith(RESET_BUTTON)) {
            this.setDisplayInfoOutput(this.initialString);
            this.setEntryFieldRangeNumber(this.initialAmount);
            this.setNTRChoiceSelection(new String[]{this.initialChoice});
            this.userTaskManager.refreshAllElements();
        } else if (actionCommand.endsWith(CANCEL)) {
            this.sendTaskletRequest(actionCommand, null);
        }
        Trace.trace(TRACE_MASKT, "<< panelAction()");
    }

    private void sendTaskletRequest(String actionCommand, Object data) {
        PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName() + '.' + actionCommand);
        request.setData("SOURCE", this.getBeanName());
        request.setData("ACTION", actionCommand);
        request.setData("DATA", data);
        this.postTaskletRequest(request);
    }

    public String getDisplayInfoOutput() {
        return this.m_sDisplayInfoOutput;
    }

    public void setDisplayInfoOutput(String s) throws IllegalUserDataException {
        this.m_sDisplayInfoOutput = s;
    }

    public double getEntryFieldRangeNumber() {
        Trace.trace(TRACE_MASKT, "[TimeRangeBean] <> getEntryFieldRangeNumber() : " + this.m_dEntryFieldRangeNumber);
        return this.m_dEntryFieldRangeNumber;
    }

    public void setEntryFieldRangeNumber(double d) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "[TimeRangeBean] <> setEntryFieldRangeNumber() : " + d);
        this.m_dEntryFieldRangeNumber = d;
    }

    public String[] getNTRChoiceSelection() {
        Trace.trace(TRACE_MASKT, "[TimeRangeBean] <> getNTRChoiceSelection() : " + (this.m_sNTRChoiceSelection == null ? null : this.m_sNTRChoiceSelection[0]));
        return this.m_sNTRChoiceSelection;
    }

    public void setNTRChoiceSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "[TimeRangeBean] <> setNTRChoiceSelection() : " + (selected == null ? null : selected[0]));
        this.m_sNTRChoiceSelection = selected;
    }

    public void load() {
        this.m_sDisplayInfoOutput = "";
        this.m_dEntryFieldRangeNumber = 0.0;
        this.m_sNTRChoiceSelection = new String[0];
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }
}

